// ==UserScript==
// @name         5ch Twitter/X 投稿埋め込み表示 改良テンプレ版 (ボタンタイプを使っているので未使用)
// @namespace    https://example.com/
// @version      1.0.17
// @description  5ch投稿内のTwitter/X URLを公式埋め込みに変換、クエリ除去・動的対応・サイズ最適化済み
// @match        *://*.5ch.net/test/read.cgi/*
// @grant        none
// ==/UserScript==

(function () {
    'use strict';

    // ✅ Twitterウィジェット読み込み
    function loadTwitterWidget() {
        return new Promise((resolve, reject) => {
            if (window.twttr && window.twttr.widgets) {
                resolve(window.twttr);
                return;
            }
            const script = document.createElement('script');
            script.src = "https://platform.twitter.com/widgets.js";
            script.async = true;
            script.onload = () => {
                if (window.twttr && window.twttr.widgets) {
                    resolve(window.twttr);
                } else {
                    reject('Twitter widget failed to load');
                }
            };
            script.onerror = () => reject('Failed to load Twitter script');
            document.head.appendChild(script);
        });
    }

    // ✅ Tweetの埋め込み処理
    async function enhanceTwitterEmbeds(post) {
        try {
            await loadTwitterWidget();
            if (window.twttr && typeof window.twttr.widgets.createTweet === 'function') {
                const blockquotes = post.querySelectorAll('blockquote.twitter-tweet');
                blockquotes.forEach(blockquote => {
                    const link = blockquote.querySelector('a');
                    if (link) {
                        const tweetUrl = link.href;
                        const idMatch = tweetUrl.match(/status\/(\d+)/);
                        if (idMatch) {
                            const tweetId = idMatch[1];
                            window.twttr.widgets.createTweet(tweetId, blockquote, {
                                theme: 'light' // 必要に応じて 'dark'
                            }).then(() => {
                                console.log(`Tweet embedded for ${tweetUrl}`);
                            }).catch(error => {
                                console.error(`Error embedding tweet for ${tweetUrl}:`, error);
                            });
                        }
                    }
                });
            }
        } catch (error) {
            console.error('Error loading Twitter widget:', error);
        }
    }

    // ✅ 投稿内のTwitter/Xリンクを blockquote に置換
    async function replaceTwitterLinks(post) {
        const anchors = post.querySelectorAll('a[href]');
        let replaced = false;

        anchors.forEach(a => {
            let href = a.href;

            if (href.startsWith('../')) {
                href = window.location.origin + href.substring(2);
            }

            const match = href.match(/^https?:\/\/(twitter\.com|x\.com)\/([^\/]+)\/status\/(\d+)/i);
            if (match && !a.closest('blockquote.twitter-tweet')) {
                const blockquote = document.createElement('blockquote');
                blockquote.className = 'twitter-tweet';
                blockquote.style.margin = '8px 0';

                // ✅ 埋め込みオプション
                blockquote.setAttribute('data-width', '200');
                blockquote.setAttribute('data-dnt', 'true');

                const link = document.createElement('a');
                link.href = href.split('?')[0]; // クエリ文字列除去
                link.textContent = a.textContent; // 元のリンクテキストを使用

                blockquote.appendChild(link);
                a.replaceWith(blockquote);
                replaced = true;
            }
        });

        if (replaced) {
            setTimeout(() => {
                console.log('Applying Twitter widgets...');
                enhanceTwitterEmbeds(post);
            }, 500);
        }
    }

    // ✅ 投稿全体の処理（初回＋追加分）
    async function processPostContent(post) {
        await replaceTwitterLinks(post);
    }

    // ✅ 初期表示分の処理
    document.querySelectorAll('.post-content').forEach(post => {
        processPostContent(post);
    });

    // ✅ 遅延読み込みの再チェック
    setTimeout(() => {
        document.querySelectorAll('.post-content').forEach(post => {
            processPostContent(post);
        });
    }, 1500);

    // ✅ DOM監視（新規投稿への対応）
    const observer = new MutationObserver(mutations => {
        for (const mutation of mutations) {
            for (const node of mutation.addedNodes) {
                if (node.nodeType !== 1) continue;
                if (node.classList.contains('post-content')) {
                    processPostContent(node);
                } else {
                    node.querySelectorAll?.('.post-content').forEach(child => {
                        processPostContent(child);
                    });
                }
            }
        }
    });

    observer.observe(document.body, {
        childList: true,
        subtree: true
    });
})();